/* GETPUT1 - LIBRARY - HEADERS */

/* ============================= */
/* COMPATIBLE WITH THE ORIGINAL  */
/* GETPUT LIBRARY MADE IN 2002   */
/* ============================= */

/* gpascii */
char get_char (byte x,byte y);
void put_char (byte x,byte y,char s);

/* gpcenter */
void center_string (byte l,char *s);

/* gpcls */
void cls(void);

/* gppause */
void pause (void);

/* gppaused */
void pause_delay(unsigned i);

/* gpprint */
void print_at (byte x, byte y,char *s);

/* ============================= */
/* THE FOLLOWING ROUTINES ARE    */
/* NOT IN THE ORIGINAL GETPUT    */
/* LIBRARY                       */
/* ============================= */

/* = RANDOM NUMBER ============= */

/* gprnd */
unsigned rnd(unsigned min, unsigned max);

/* gprndb */
byte rnd_byte(byte min, byte max);

/* = CONVERT UNSIGNED TO STRING  */

/* gpstr */
char *str(unsigned value);

/* = DEFAULT INITVDP ROUTINES == */

/* gpbitmap */
void show_picture(void *picture);
void screen_mode_2_bitmap(void);

/* gptext */
void screen_mode_2_text(void);

/* gpchar */
void upload_default_ascii(byte flags);

/* = CHANGE BACKGROUND COLOR === */

/* gppaper */
void paper(byte color);

/* ROUTINES BASED ON ICVGM DATA  */

/* gpcolor */
void load_color(byte *color);

/* gpnamrle */
void load_namerle(byte *namerle);

/* gppatrle */
void load_patternrle(byte *patternrle);

/* gpsptrle */
void load_spatternrle(byte *spatternrle);

/* TO UPDATE CHARSET AND SPRITES */

/* gp2 */
void change_pattern(byte c, byte *pattern, byte l);

/* gp2s */
void change_spattern(byte s, byte *pattern, byte N);

/* gp2color */
void change_color(byte c, byte *color, byte l);

/* gp2fill */
void fill_color(byte c, byte color, byte n);

/* gp2multi */
void change_multicolor(byte c, byte *color);
void change_multicolor_pattern(byte c, byte *color, byte n);

/* = GET VALUE FROM KEYPAD ===== */

/* gp2choic1 */
byte choice_keypad_1(byte min, byte max);

/* gp2choic2 */
byte choice_keypad_2(byte min, byte max);

/* = USE THIS IF YOU DONT KNOW = */
/* = HOW TO USE update_sprites = */

/* gpupdats */
void updatesprites(byte first, byte count);

/* = TO CHANGE SPRITES MODE ==== */

/* gpspritm */
void sprites_simple(void);
void sprites_double(void);

/* gpsprits */
void sprites_8x8(void);
void sprites_16x16(void);

/* ============================= */

/* Joystick Axes */

#define	UP      1
#define	RIGHT   2
#define	DOWN    4
#define	LEFT    8
#define	FIRE4   16
#define	FIRE3   32
#define	FIRE2   64
#define	FIRE1   128

/* ============================= */
/* ===    SPECIAL EFFECTS    === */
/* ===   FOR BITMAP SCREEN   === */
/* ============================= */

/* gpwipedn */
void wipe_off_down(void);

/* gpwipeup */
void wipe_off_up(void);